<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
$decoded = JWT::authenticate();
$database = new Database();
$db = $database->getConnection();

$query = "SELECT * FROM absen ORDER BY tanggal DESC";
$stmt = $db->prepare($query);
$stmt->execute();

$num = $stmt->rowCount();

if ($num > 0) {
    $absen_arr = array();
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        extract($row);
        
        $absen_item = array(
            'id' => $id,
            'siswa' => $siswa,
            'mata_pelajaran' => $mata_pelajaran,
            'keterangan' => $keterangan,
            'tanggal' => $tanggal,
            'created_at' => $created_at
        );
        
        array_push($absen_arr, $absen_item);
    }
    
    response($absen_arr);
} else {
    response(['message' => 'No absen found']);
}
?>