<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
$decoded = JWT::authenticate();
$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (
    !empty($data->siswa) &&
    !empty($data->mata_pelajaran) &&
    !empty($data->keterangan) &&
    !empty($data->tanggal)
) {
    $query = "INSERT INTO absen SET siswa=:siswa, mata_pelajaran=:mata_pelajaran, keterangan=:keterangan, tanggal=:tanggal";
    $stmt = $db->prepare($query);
    
    // Sanitize
    $data->siswa = htmlspecialchars(strip_tags($data->siswa));
    $data->mata_pelajaran = htmlspecialchars(strip_tags($data->mata_pelajaran));
    $data->keterangan = htmlspecialchars(strip_tags($data->keterangan));
    $data->tanggal = htmlspecialchars(strip_tags($data->tanggal));
    
    $stmt->bindParam(':siswa', $data->siswa);
    $stmt->bindParam(':mata_pelajaran', $data->mata_pelajaran);
    $stmt->bindParam(':keterangan', $data->keterangan);
    $stmt->bindParam(':tanggal', $data->tanggal);
    
    if ($stmt->execute()) {
        $absen_id = $db->lastInsertId();
        
        response([
            'message' => 'Absen created successfully',
            'id' => $absen_id
        ], 201);
    } else {
        error('Unable to create absen');
    }
} else {
    error('Incomplete data');
}
?>