<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (
    !empty($data->email) &&
    !empty($data->password)
) {
    $query = "SELECT id, name, email, password, role FROM users WHERE email = :email LIMIT 1";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':email', $data->email);
    $stmt->execute();
    $num = $stmt->rowCount();
    
    if ($num > 0) {
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (password_verify($data->password, $row['password'])) {
            // Ambil informasi kelas jika role adalah siswa
            $kelas = '';
            if ($row['role'] === 'Siswa') {
                // Query untuk mendapatkan kelas siswa
                $kelasQuery = "SELECT kelas FROM siswa WHERE user_id = :user_id";
                $kelasStmt = $db->prepare($kelasQuery);
                $kelasStmt->bindParam(':user_id', $row['id']);
                $kelasStmt->execute();
                $kelasRow = $kelasStmt->fetch(PDO::FETCH_ASSOC);
                $kelas = $kelasRow['kelas'] ?? '';
            }
            
            $payload = [
                'iss' => 'localhost',
                'aud' => 'localhost',
                'iat' => time(),
                'exp' => time() + (60 * 60 * 24), // Token expires in 24 hours
                'data' => [
                    'id' => $row['id'],
                    'name' => $row['name'],
                    'email' => $row['email'],
                    'role' => $row['role'],
                    'kelas' => $kelas // Tambahkan kelas ke token
                ]
            ];
            
            $token = JWT::encode($payload);
            
            response([
                'message' => 'Login successful',
                'token' => $token,
                'user' => [
                    'id' => $row['id'],
                    'name' => $row['name'],
                    'email' => $row['email'],
                    'role' => $row['role'],
                    'kelas' => $kelas
                ]
            ]);
        } else {
            error('Invalid password');
        }
    } else {
        error('User not found');
    }
} else {
    error('Incomplete data');
}
?>