<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/auth_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
// $decoded = JWT::authenticate();
$decoded = Auth::checkRole(['superadmin','Kepala Sekolah', 'Wali Kelas', 'Guru', 'Siswa']);
$database = new Database();
$db = $database->getConnection();

$userRole = $decoded->data->role;
$userKelas = $decoded->data->kelas ?? '';

if($userRole == 'superadmin' || $userRole == 'Kepala Sekolah'){
    // Jika superadmin atau kepala sekolah, ambil semua jadwal
    $query = "SELECT * FROM jadwal ORDER BY hari, jam_mulai";
    $stmt = $db->prepare($query);
    $stmt->execute();
    
    $num = $stmt->rowCount();
    
    if ($num > 0) {
        $jadwal_arr = array();
        
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            extract($row);
            
            $jadwal_item = array(
                'id' => $id,
                'hari' => $hari,
                'jam_mulai' => $jam_mulai,
                'jam_selesai' => $jam_selesai,
                'mata_pelajaran' => $mata_pelajaran,
                'guru' => $guru,
                'kelas' => $kelas,
                'created_at' => $created_at
            );
            
            array_push($jadwal_arr, $jadwal_item);
        }
        
        response($jadwal_arr);
    } else {
        response(['message' => 'No jadwal found']);
    }
    exit();
}elseif($userRole == 'Guru'){
    // Jika guru, ambil jadwal berdasarkan mata pelajaran yang diajarkan
    $query = "SELECT * FROM jadwal WHERE guru = :guru ORDER BY hari, jam_mulai";
    $stmt = $db->prepare($query);
    $guru = $decoded->data->name;
    $stmt->bindParam(':guru', $guru);
} elseif($userRole == 'Siswa') {
    // Jika siswa, ambil jadwal berdasarkan kelas
    $query = "SELECT * FROM jadwal WHERE kelas = :kelas ORDER BY hari, jam_mulai";
    $stmt = $db->prepare($query);
    $kelas = $decoded->data->kelas;
    $stmt->bindParam(':kelas', $kelas);
} elseif($userRole == 'Wali Kelas') {
    // Jika wali kelas, ambil jadwal berdasarkan kelas yang diawali dengan "Wali-"
    $query = "SELECT * FROM jadwal WHERE kelas = :kelas ORDER BY hari, jam_mulai";
    $stmt = $db->prepare($query);
    $kelas = str_replace('Wali-', '', $decoded->data->nama);
    $stmt->bindParam(':kelas', $kelas);
} else {
    http_response_code(403);
    echo json_encode(['message' => 'Access denied. Insufficient privileges.']);
    exit();
}

$stmt->execute();

$num = $stmt->rowCount();

if ($num > 0) {
    $jadwal_arr = array();
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        extract($row);
        
        $jadwal_item = array(
            'id' => $id,
            'hari' => $hari,
            'jam_mulai' => $jam_mulai,
            'jam_selesai' => $jam_selesai,
            'mata_pelajaran' => $mata_pelajaran,
            'guru' => $guru,
            'kelas' => $kelas,
            'created_at' => $created_at
        );
        
        array_push($jadwal_arr, $jadwal_item);
    }
    
    response($jadwal_arr);
} else {
    response(['message' => 'No jadwal found']);
}
?>