<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: DELETE');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
$decoded = JWT::authenticate();
$database = new Database();
$db = $database->getConnection();

// Get ID from URL
$id = isset($_GET['id']) ? $_GET['id'] : die();

$query = "DELETE FROM pengumuman WHERE id=:id";
$stmt = $db->prepare($query);
$stmt->bindParam(':id', $id);

if ($stmt->execute()) {
    if ($stmt->rowCount() > 0) {
        response([
            'message' => 'Pengumuman deleted successfully'
        ]);
    } else {
        error('Pengumuman not found');
    }
} else {
    error('Unable to delete pengumuman');
}
?>