<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: PUT');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
$decoded = JWT::authenticate();
$database = new Database();
$db = $database->getConnection();

// Get ID from URL
$id = isset($_GET['id']) ? $_GET['id'] : die();

$data = json_decode(file_get_contents("php://input"));

if (
    !empty($data->judul) &&
    !empty($data->mata_pelajaran) &&
    !empty($data->guru) &&
    !empty($data->mulai) &&
    !empty($data->durasi)
) {
    $query = "UPDATE ujian SET judul=:judul, mata_pelajaran=:mata_pelajaran, guru=:guru, mulai=:mulai, durasi=:durasi, status=:status WHERE id=:id";
    $stmt = $db->prepare($query);
    
    // Sanitize
    $data->judul = htmlspecialchars(strip_tags($data->judul));
    $data->mata_pelajaran = htmlspecialchars(strip_tags($data->mata_pelajaran));
    $data->guru = htmlspecialchars(strip_tags($data->guru));
    $data->mulai = htmlspecialchars(strip_tags($data->mulai));
    $data->durasi = htmlspecialchars(strip_tags($data->durasi));
    
    $status = $data->status ?? 'belum_mulai';
    
    $stmt->bindParam(':id', $id);
    $stmt->bindParam(':judul', $data->judul);
    $stmt->bindParam(':mata_pelajaran', $data->mata_pelajaran);
    $stmt->bindParam(':guru', $data->guru);
    $stmt->bindParam(':mulai', $data->mulai);
    $stmt->bindParam(':durasi', $data->durasi);
    $stmt->bindParam(':status', $status);
    
    if ($stmt->execute()) {
        response([
            'message' => 'Ujian updated successfully'
        ]);
    } else {
        error('Unable to update ujian');
    }
} else {
    error('Incomplete data');
}
?>