<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: PUT');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
$decoded = JWT::authenticate();
$database = new Database();
$db = $database->getConnection();

// Get ID from URL
$id = isset($_GET['id']) ? $_GET['id'] : die();

$data = json_decode(file_get_contents("php://input"));

if (
    !empty($data->hari) &&
    !empty($data->jam_mulai) &&
    !empty($data->jam_selesai) &&
    !empty($data->mata_pelajaran) &&
    !empty($data->guru) &&
    !empty($data->kelas)
) {
    $query = "UPDATE jadwal SET hari=:hari, jam_mulai=:jam_mulai, jam_selesai=:jam_selesai, mata_pelajaran=:mata_pelajaran, guru=:guru, kelas=:kelas WHERE id=:id";
    $stmt = $db->prepare($query);
    
    // Sanitize
    $data->hari = htmlspecialchars(strip_tags($data->hari));
    $data->jam_mulai = htmlspecialchars(strip_tags($data->jam_mulai));
    $data->jam_selesai = htmlspecialchars(strip_tags($data->jam_selesai));
    $data->mata_pelajaran = htmlspecialchars(strip_tags($data->mata_pelajaran));
    $data->guru = htmlspecialchars(strip_tags($data->guru));
    $data->kelas = htmlspecialchars(strip_tags($data->kelas));
    
    $stmt->bindParam(':id', $id);
    $stmt->bindParam(':hari', $data->hari);
    $stmt->bindParam(':jam_mulai', $data->jam_mulai);
    $stmt->bindParam(':jam_selesai', $data->jam_selesai);
    $stmt->bindParam(':mata_pelajaran', $data->mata_pelajaran);
    $stmt->bindParam(':guru', $data->guru);
    $stmt->bindParam(':kelas', $data->kelas);
    
    if ($stmt->execute()) {
        response([
            'message' => 'Jadwal updated successfully'
        ]);
    } else {
        error('Unable to update jadwal');
    }
} else {
    error('Incomplete data');
}
?>