<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
$decoded = JWT::authenticate();
$database = new Database();
$db = $database->getConnection();

$query = "SELECT * FROM payment ORDER BY created_at DESC";
$stmt = $db->prepare($query);
$stmt->execute();

$num = $stmt->rowCount();

if ($num > 0) {
    $payment_arr = array();
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        extract($row);
        
        $payment_item = array(
            'id' => $id,
            'kode' => $kode,
            'nama' => $nama,
            'jumlah' => $jumlah,
            'is_paid' => (bool)$is_paid,
            'paid_at' => $paid_at,
            'siswa' => $siswa,
            'created_at' => $created_at
        );
        
        array_push($payment_arr, $payment_item);
    }
    
    response($payment_arr);
} else {
    response(['message' => 'No payment found']);
}
?>