<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: PUT');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
$decoded = JWT::authenticate();
$database = new Database();
$db = $database->getConnection();

// Get ID from URL
$id = isset($_GET['id']) ? $_GET['id'] : die();

$data = json_decode(file_get_contents("php://input"));

if (
    !empty($data->kode) &&
    !empty($data->nama) &&
    !empty($data->jumlah) &&
    !empty($data->siswa)
) {
    $query = "UPDATE payment SET kode=:kode, nama=:nama, jumlah=:jumlah, is_paid=:is_paid, paid_at=:paid_at, siswa=:siswa WHERE id=:id";
    $stmt = $db->prepare($query);
    
    // Sanitize
    $data->kode = htmlspecialchars(strip_tags($data->kode));
    $data->nama = htmlspecialchars(strip_tags($data->nama));
    $data->jumlah = htmlspecialchars(strip_tags($data->jumlah));
    $data->siswa = htmlspecialchars(strip_tags($data->siswa));
    
    $is_paid = $data->is_paid ?? false;
    $paid_at = $is_paid ? date('Y-m-d H:i:s') : null;
    
    $stmt->bindParam(':id', $id);
    $stmt->bindParam(':kode', $data->kode);
    $stmt->bindParam(':nama', $data->nama);
    $stmt->bindParam(':jumlah', $data->jumlah);
    $stmt->bindParam(':is_paid', $is_paid);
    $stmt->bindParam(':paid_at', $paid_at);
    $stmt->bindParam(':siswa', $data->siswa);
    
    if ($stmt->execute()) {
        response([
            'message' => 'Payment updated successfully'
        ]);
    } else {
        error('Unable to update payment');
    }
} else {
    error('Incomplete data');
}
?>