<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
$decoded = JWT::authenticate();
$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (
    !empty($data->judul) &&
    !empty($data->isi) &&
    !empty($data->kategori)
) {
    $query = "INSERT INTO pengumuman SET judul=:judul, isi=:isi, kategori=:kategori";
    $stmt = $db->prepare($query);
    
    // Sanitize
    $data->judul = htmlspecialchars(strip_tags($data->judul));
    $data->isi = htmlspecialchars(strip_tags($data->isi));
    $data->kategori = htmlspecialchars(strip_tags($data->kategori));
    
    $stmt->bindParam(':judul', $data->judul);
    $stmt->bindParam(':isi', $data->isi);
    $stmt->bindParam(':kategori', $data->kategori);
    
    if ($stmt->execute()) {
        $pengumuman_id = $db->lastInsertId();
        
        response([
            'message' => 'Pengumuman created successfully',
            'id' => $pengumuman_id
        ], 201);
    } else {
        error('Unable to create pengumuman');
    }
} else {
    error('Incomplete data');
}
?>