<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
$decoded = JWT::authenticate();
$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (
    !empty($data->siswa) &&
    !empty($data->mata_pelajaran) &&
    !empty($data->nilai) &&
    !empty($data->keterangan)
) {
    $query = "INSERT INTO rapor SET siswa=:siswa, mata_pelajaran=:mata_pelajaran, nilai=:nilai, keterangan=:keterangan, is_locked=:is_locked";
    $stmt = $db->prepare($query);
    
    // Sanitize
    $data->siswa = htmlspecialchars(strip_tags($data->siswa));
    $data->mata_pelajaran = htmlspecialchars(strip_tags($data->mata_pelajaran));
    $data->nilai = htmlspecialchars(strip_tags($data->nilai));
    $data->keterangan = htmlspecialchars(strip_tags($data->keterangan));
    
    $is_locked = $data->is_locked ?? false;
    
    $stmt->bindParam(':siswa', $data->siswa);
    $stmt->bindParam(':mata_pelajaran', $data->mata_pelajaran);
    $stmt->bindParam(':nilai', $data->nilai);
    $stmt->bindParam(':keterangan', $data->keterangan);
    $stmt->bindParam(':is_locked', $is_locked);
    
    if ($stmt->execute()) {
        $rapor_id = $db->lastInsertId();
        
        response([
            'message' => 'Rapor created successfully',
            'id' => $rapor_id
        ], 201);
    } else {
        error('Unable to create rapor');
    }
} else {
    error('Incomplete data');
}
?>