<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
$decoded = JWT::authenticate();
$database = new Database();
$db = $database->getConnection();

$query = "SELECT * FROM tugas ORDER BY created_at DESC";
$stmt = $db->prepare($query);
$stmt->execute();

$num = $stmt->rowCount();

if ($num > 0) {
    $tugas_arr = array();
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        extract($row);
        
        $tugas_item = array(
            'id' => $id,
            'judul' => $judul,
            'deskripsi' => $deskripsi,
            'mata_pelajaran' => $mata_pelajaran,
            'guru' => $guru,
            'attachments' => json_decode($attachments),
            'deadline' => $deadline,
            'created_at' => $created_at
        );
        
        array_push($tugas_arr, $tugas_item);
    }
    
    response($tugas_arr);
} else {
    response(['message' => 'No tugas found']);
}
?>