<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: DELETE');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
$decoded = JWT::authenticate();
$database = new Database();
$db = $database->getConnection();

// Get ID from URL
$id = isset($_GET['id']) ? $_GET['id'] : die();

// First, delete related soal_ujian
$query = "DELETE FROM soal_ujian WHERE ujian_id=:ujian_id";
$stmt = $db->prepare($query);
$stmt->bindParam(':ujian_id', $id);
$stmt->execute();

// Then delete ujian
$query = "DELETE FROM ujian WHERE id=:id";
$stmt = $db->prepare($query);
$stmt->bindParam(':id', $id);

if ($stmt->execute()) {
    if ($stmt->rowCount() > 0) {
        response([
            'message' => 'Ujian deleted successfully'
        ]);
    } else {
        error('Ujian not found');
    }
} else {
    error('Unable to delete ujian');
}
?>