<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require_once '../../config/database.php';
require_once '../../helpers/jwt_helper.php';
require_once '../../helpers/response_helper.php';

// Authenticate user
$decoded = JWT::authenticate();
$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (
    !empty($data->judul) &&
    !empty($data->mata_pelajaran) &&
    !empty($data->guru) &&
    !empty($data->mulai) &&
    !empty($data->durasi)
) {
    $query = "INSERT INTO ujian SET judul=:judul, mata_pelajaran=:mata_pelajaran, guru=:guru, mulai=:mulai, durasi=:durasi, status=:status";
    $stmt = $db->prepare($query);
    
    // Sanitize
    $data->judul = htmlspecialchars(strip_tags($data->judul));
    $data->mata_pelajaran = htmlspecialchars(strip_tags($data->mata_pelajaran));
    $data->guru = htmlspecialchars(strip_tags($data->guru));
    $data->mulai = htmlspecialchars(strip_tags($data->mulai));
    $data->durasi = htmlspecialchars(strip_tags($data->durasi));
    
    $status = 'belum_mulai';
    
    $stmt->bindParam(':judul', $data->judul);
    $stmt->bindParam(':mata_pelajaran', $data->mata_pelajaran);
    $stmt->bindParam(':guru', $data->guru);
    $stmt->bindParam(':mulai', $data->mulai);
    $stmt->bindParam(':durasi', $data->durasi);
    $stmt->bindParam(':status', $status);
    
    if ($stmt->execute()) {
        $ujian_id = $db->lastInsertId();
        
        response([
            'message' => 'Ujian created successfully',
            'id' => $ujian_id
        ], 201);
    } else {
        error('Unable to create ujian');
    }
} else {
    error('Incomplete data');
}
?>